/**
 * i-net software provides programming examples for illustration only, without warranty
 * either expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and/or fitness for a particular purpose. This programming example
 * assumes that you are familiar with the programming language being demonstrated and
 * the tools used to create and debug procedures. i-net software support professionals
 * can help explain the functionality of a particular procedure, but they will not modify
 * these examples to provide added functionality or construct procedures to meet your
 * specific needs.
 *
 * Copyright © 1999-2026 i-net software GmbH, Berlin, Germany.
**/
package printing;

/*
i-net software provides programming examples for illustration only, without warranty
either expressed or implied, including, but not limited to, the implied warranties
of merchantability and/or fitness for a particular purpose. This programming example
assumes that you are familiar with the programming language being demonstrated and
the tools used to create and debug procedures. i-net software support professionals
can help explain the functionality of a particular procedure, but they will not modify
these examples to provide added functionality or construct procedures to meet your
specific needs.
© i-net software 1998-2015
*/

import java.awt.print.PrinterJob;

import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;

import com.inet.report.EngineRenderData;
import com.inet.viewer.PrinterJobProgress;
import com.inet.viewer.Progress;
import com.inet.viewer.RenderData;

/**
 * This sample print without a server with an embedded reporting engine. This is typical used in the server self.
 */
public class PrintingWithoutServer {

    /**
     * Main method of the sample.
     * @param args no parameters used
     */
    public static void main( String[] args ) {
        // The render data connection.
        RenderData data = new EngineRenderData( "report=" + PrintingWithoutServer.class.getResource( "../sample.rpt" ) );

        // Create the printer job.
        PrinterJob printerJob = PrinterJob.getPrinterJob(); //default printer

        // Start the asynchrony printing
        PrintRequestAttributeSet printAttributes = new HashPrintRequestAttributeSet();
        Progress progress = new PrinterJobProgress( null, printerJob, printAttributes, data );
        progress.startProgress();

        // optional waiting on finish
        progress.waitUntilFinished();
    }

}
